function test_suite = testMakeSameSize %#ok<STOUT>
initTestSuite;

function testBothScalar %#ok<*DEFNU>
out = callMakeSameSize(1,1);
assertEqual(numel(out),1);
assertEqual(out.newValue1,'1');
assertEqual(out.newValue2,'1');

function testZeroScalars
in1 = 0;
in2 = 0;
out = callMakeSameSize(in1,in2);
assertEqual(numel(out),1);
assertEqual(out.newValue1,'0');
assertEqual(out.newValue2,'0');

function testFirstVector
in1 = [1 2];
in2 = 3;
out = callMakeSameSize(in1,in2);
assertEqual(numel(out),2);
assertEqual(out(1).newValue1,'1');
assertEqual(out(2).newValue1,'2');
assertEqual(out(1).newValue2,'3');
assertEqual(out(2).newValue2,'3');

function testSecondVector
in2 = [1 2];
in1 = 3;
out = callMakeSameSize(in1,in2);
assertEqual(numel(out),2);
assertEqual(out(1).newValue1,'3');
assertEqual(out(2).newValue1,'3');
assertEqual(out(1).newValue2,'1');
assertEqual(out(2).newValue2,'2');

function testCell
in1 = 's';
in2 = {'t','u'};
out = callMakeSameSize(in1,in2);
assertEqual(numel(out),2);
assertEqual(out(1).newValue1,'s');
assertEqual(out(2).newValue1,'s');
assertEqual(out(1).newValue2,'t');
assertEqual(out(2).newValue2,'u');

function testMatrix
in1 = 's';
in2 = [1 2; 3 4];
out = callMakeSameSize(in1,in2);
assertEqual(size(out,1),2);
assertEqual(size(out,2),2);
assertEqual(out(1,1).newValue1,'s');
assertEqual(out(1,2).newValue1,'s');
assertEqual(out(2,1).newValue1,'s');
assertEqual(out(2,2).newValue1,'s');
assertEqual(out(1,1).newValue2,'1');
assertEqual(out(1,2).newValue2,'2');
assertEqual(out(2,1).newValue2,'3');
assertEqual(out(2,2).newValue2,'4');
